// Const
var APP_CONST = {
    'KG/M3': 1000,
    'KJ/KGoC': 4.2,
    '1BTU': 0.0002930710701, // KW/H
    '1ft2': 0.92903 // M2
};

var COLOURS = [{
        fillColor: '#0087e2',
        strokeColor: '#0087e2'
    },
    {
        fillColor: '#2ea306',
        strokeColor: '#2ea306'
    }
];


var calApp = angular.module('calApp', ['chart.js']);
calApp.controller('mainCtrl', ['$scope', '$http', '$q', '$filter', mainCtrl]);

function mainCtrl(scope, http, q, filter) {
    // Show spinner by default
    scope.spinner = {
        active: true
    };

    // Initial data
    scope.types = ['Pool', 'Spa'];
    scope.countries = ['Australia', 'New Zealand'];
    scope.withCovers = [{
        value: true,
        text: 'Yes'
    }, {
        value: false,
        text: 'No'
    }];
    scope.australiaStates = ['NSW', 'VIC', 'QLD', 'SA', 'NT', 'WA', 'TAS', 'ACT'];
    scope.monthNames = ['jan', 'feb', 'apr', 'may', 'jun', 'jul', 'aug', 'sep', 'oct', 'nov', 'dec'];
    scope.cities = [{
        state: 'NSW',
        cities: [
            'CAMPBELLTOWN',
            'COFFS HARBOUR',
            'FORBES',
            'GOULBURN',
            'LISMORE',
            'NEWCASTLE',
            'PORT MACQUARIE',
            'SYDNEY',
            'WOLLONGONG',
            'BROKEN HILL',
            'THREDBO',
            'PENRITH',
            'TAMWORTH'
        ]
    }, {
        state: 'VIC',
        cities: [
            'GEELONG',
            'MELBOURNE',
            'WODONGA',
            'WARRNAMBOOL',
            'BENDIGO',
            'BAIRNSDALE'
        ]
    }, {
        state: 'QLD',
        cities: [
            'BRISBANE',
            'CAIRNS',
            'ROCKHAMPTON',
            'TOWNSVILLE',
            'TOOWOOMBA',
            'IPSWICH',
            'MACKAY',
            'HERVEY BAY'
        ]
    }, {
        state: 'SA',
        cities: [
            'ADELAIDE',
            'MOUNT GAMBIER',
            'WHYALLA',
            'LOXTON'
        ]
    }, {
        state: 'NT',
        cities: [
            'ALICE SPRINGS',
            'DARWIN'
        ]
    }, {
        state: 'WA',
        cities: [
            'MANDURAH',
            'PERTH',
            'BUNBURY',
            'GERALDTON'
        ]
    }, {
        state: 'TAS',
        cities: [
            'HOBART',
            'LAUNCESTON'
        ]
    }, {
        state: 'ACT',
        cities: [
            'CANBERRA'
        ]
    }];
    scope.citiesOfNZ = [
        'AUCKLAND',
        'CHRISTCHURCH',
        'WELLINGTON'
    ];

    scope.defaultMonthTemperatureByCity = [];
    scope.defaultTotalHeat = [];
    scope.monthCheckboxs = [];
    scope.defaultModel = [];
    scope.defaultCostArr = [];
    scope.totalCost = 0;
    scope.defaultInputArr = [];
    for (var i = 0; i < 12; i++) {
        scope.defaultMonthTemperatureByCity.push(0);
        scope.monthCheckboxs.push(true);
        scope.defaultTotalHeat.push(0);
        scope.defaultModel.push(0);
        scope.defaultCostArr.push(0);
        scope.defaultInputArr.push(0);
    }

    scope.monthTemperatureByCity = angular.copy(scope.defaultMonthTemperatureByCity);
    scope.totalHeat = angular.copy(scope.defaultTotalHeat);
    scope.model = angular.copy(scope.defaultModel);
    scope.costArr = angular.copy(scope.defaultCostArr);
    scope.inputArr = angular.copy(scope.defaultInputArr);

    scope.itemTypes = ['AboveGround', 'Inground'];
    scope.shapes = ['Square', 'Rectangle', 'Kidney', 'Round'];
    scope.locations = ['Indoor', 'Outdoor'];
    scope.electroCapacity = [12, 15, 19, 23, 16, 25, 25, 31, 37, 9, 44];
    scope.maximumTempRaise = 28;
    scope.startingTemp = 0;
    scope.itemType = scope.itemTypes[0];
    scope.location = scope.locations[0];
    scope.shape = scope.shapes[0];
    scope.diameter = 0;
    scope.depth = 0;
    scope.width = 0;
    scope.length = 0;
    scope.operatingHours = 8;
    scope.requirePoolTemp = 0;
    scope.state = 'WA';
    scope.city = 'PERTH';
    scope.itemType = 'Inground';
    scope.location = 'Outdoor';
    scope.shape = 'Rectangle';
    scope.length = 9.5;
    scope.width = 4.5;
    scope.depth = 1.3;
    scope.electricityCost = 0.29;
    scope.tempHeatTotal = [];

    // Watching changes
    scope.$watch('[country]', function() {
        if (scope.country === 'Australia') {
            scope.currentCountryStates = scope.australiaStates;
            scope.state = scope.currentCountryStates[0];
        } else if (scope.country === 'New Zealand') {
            scope.currentCountryStates = [];
            scope.state = '';
        }
    }, true);

    scope.$watch('[state]', function() {
        if (scope.state) {
            var filter = scope.cities.filter(function(a) {
                return a.state === scope.state
            });
            scope.currentStateCities = filter[0].cities;
        } else {
            scope.currentStateCities = scope.citiesOfNZ;
        }
        scope.city = scope.currentStateCities[0];
    }, true);

    scope.$watch('[city]', function() {
        getTempByCityAndState(scope);
    }, true);

    scope.$watch('[shape,width,depth,length,diameter,requirePoolTemp,type,location,electricityCost,withCover,operatingHours]', function() {
        if (scope.shape === 'Round') {
            scope.estimateVol = scope.diameter / 2 * scope.diameter / 2 * scope.depth;
        } else {
            scope.estimateVol = scope.width * scope.length * scope.depth;
        }
        scope.estimateVolDisplay = filter('number')(scope.estimateVol, 0);
        calculateSurfaceArea(scope);
    }, true);


    scope.$watch('[monthCheckboxs]', function() {
        getTempByCityAndState(scope);
        calculateHeat(scope);
        calculateModel(scope);
    }, true);

    // Initial values
    scope.type = scope.types[0];
    scope.country = scope.countries[0];
    scope.withCover = scope.withCovers[0];






    // Get server data
    q.all([
        http.get('/pages/heat_pump_calculator_data/temps'),
        http.get('/pages/heat_pump_calculator_data/pumps'),
        http.get('/pages/heat_pump_calculator_data/lookup'),
        http.get('/pages/heat_pump_calculator_data/daysinmonth')
    ]).then(function(serverDataArr) {
        // Hide spinner after data loaded
        scope.spinner.active = false;
        var tempByCityResponse = serverDataArr[0];
        var c59c69Response = serverDataArr[1];
        var a76e87Response = serverDataArr[2];
        var monthsanddatesResponse = serverDataArr[3];

        if (tempByCityResponse.status === 200) {
            scope.tempByCitiesAndMonthsData = Papa.parse(tempByCityResponse.data, {
                header: true
            }).data;
            getTempByCityAndState(scope);
        }
        if (c59c69Response.status === 200) {
            scope.c59c69Data = Papa.parse(c59c69Response.data, {
                header: true
            }).data;
        }

        if (a76e87Response.status === 200) {
            scope.a76e87Data = Papa.parse(a76e87Response.data, {
                header: true
            }).data;
        }

        if (monthsanddatesResponse.status === 200) {
            scope.monthsanddatesData = Papa.parse(monthsanddatesResponse.data, {
                header: true
            }).data;
        }

        scope.requirePoolTemp = 28;
    });


    function getTempByCityAndState(scope) {
        if (scope.tempByCitiesAndMonthsData && scope.tempByCitiesAndMonthsData.length) {
            var cloneData = angular.copy(scope.tempByCitiesAndMonthsData);
            var filter = cloneData.filter(function(a) {
                if (scope.state) {
                    return a.City === scope.city && a.State === scope.state;
                } else {
                    return a.City === scope.city;
                }
            });

            if (filter && filter.length) {
                var arr = filter[0];
                scope.monthCheckboxs.forEach(function(item, index) {
                    if (!item) {
                        arr[index + 1] = 0;
                    }
                });
                scope.monthTemperatureByCity = arr;
            } else {
                scope.monthTemperatureByCity = angular.copy(scope.defaultMonthTemperatureByCity);
            }

            calculateHeat(scope);
            calculateModel(scope);
            if (scope.withCoverVal && scope.withoutCoverVal) {
                scope.chartData = {};
                scope.chartData.labels = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
                scope.chartData.series = ['Covered', 'Without Cover'];
                scope.chartData.data = [scope.withoutCoverVal, scope.withCoverVal];
                scope.chartData.colours = COLOURS;

                if (!scope.isShowAlert) {
                    var start = 0;
                    var step = 10;
                    var max = 50;
                    scope.chartData.options = {
                        scaleOverride: true,
                        scaleSteps: Math.ceil((max - start) / step),
                        scaleStepWidth: step,
                        scaleStartValue: start
                    };
                } else {
                    scope.chartData.options = {
                        scaleOverride: false
                    };
                }
            }
        }
    }

    function calculateHeat(scope) {
        // Calculate heat
        var heatTotalData = [],
            tempHeatTotal = [],
            heatUpArr = [];
        for (var i = 1; i < 13; i++) {
            var item = scope.monthTemperatureByCity[i];
            var heatUp, heatSurfaceLost, heatTotal;
            if (item <= 0 || item >= scope.requirePoolTemp) {
                heatUp = 0;
                heatSurfaceLost = 0;
            } else {
                // calculate heatUp
                if (scope.requirePoolTemp - item >= 25 && scope.type === 'Pool') {
                    heatUp = APP_CONST['KG/M3'] * APP_CONST['KJ/KGoC'] * scope.estimateVol * 6 / (scope.operatingHours * 3600);
                } else {
                    heatUp = APP_CONST['KG/M3'] * APP_CONST['KJ/KGoC'] * scope.estimateVol * (scope.requirePoolTemp - item) / (scope.operatingHours * 3600);
                }
                heatUpArr.push(heatUp);
                // calculate heatSurfaceLost
                if (scope.type === 'Pool' || scope.type === 'Spa') {
                    if (scope.location === 'Indoor') {
                        if (!scope.withCover.value) {
                            heatSurfaceLost = 30 * APP_CONST['1BTU'] * scope.surfaceAreaTop * (scope.requirePoolTemp - item) * 0.75;
                        } else {
                            heatSurfaceLost = 3 * APP_CONST['1BTU'] * scope.surfaceAreaTop * (scope.requirePoolTemp - item);
                        }
                    } else {
                        if (!scope.withCover.value) {
                            heatSurfaceLost = 7 * APP_CONST['1BTU'] * scope.surfaceAreaTop * (scope.requirePoolTemp - item);
                        } else {
                            heatSurfaceLost = 7 * APP_CONST['1BTU'] * scope.surfaceAreaTop * (scope.requirePoolTemp - item) * 0.45;
                        }
                    }
                }
            }

            if (heatUp != 0 && scope.withCover.value) {
                heatTotal = 0.8 * (heatUp + heatSurfaceLost) * 0.3;
            } else {
                heatTotal = 0.5 * (heatUp + heatSurfaceLost);
            }

            tempHeatTotal.push(heatTotal);

            if (scope.withCover.value) {
                if (i < 5) {
                    heatTotal = 0.05 * heatTotal;
                } else {
                    heatTotal = 0.101 * heatTotal;
                }
            }
            if (!scope.monthCheckboxs[i - 1]) {
                heatTotal = 0;
            }

            heatTotalData.push(heatTotal);
        }

        scope.heatTotalData = heatTotalData;
        scope.tempHeatTotal = tempHeatTotal;
        scope.heatUpArr = heatUpArr;
    }

    function calculateModel(scope) {
        if (scope.c59c69Data && scope.c59c69Data.length && scope.a76e87Data && scope.a76e87Data.length && scope.monthsanddatesData && scope.monthsanddatesData.length) {
            scope.totalCost = 0;
            var model = [],
                costArr = [],
                inputArr = [],
                withCoverVal = [],
                withoutCoverVal = [];
            for (var i = 0; i < 12; i++) {
                var tempArrData = angular.copy(scope.c59c69Data);
                var tempArrDataQuantity = angular.copy(scope.c59c69Data);
                var runningCostEstimate, recommendedModel, modelInputPower,
                    countIf = 0,
                    large = 0,
                    match = 0,
                    index = 0,
                    tempModel, cost, input, quantity,
                    countIfQuantity = 0,
                    largeQuantity = 0,
                    matchQuantity = 0,
                    indexQuantity = 0,
                    requireApprox, status, modelInputKwPower, top;

                runningCostEstimate = Math.round(scope.tempHeatTotal[i] * 10) / 10;

                //calculate recommended model
                if (runningCostEstimate > 44) {
                    var filterc59c69Data = scope.c59c69Data.filter(function(a) {
                        return a.Capacity >= 44;
                    });
                    if (filterc59c69Data.length > 0) {
                        recommendedModel = filterc59c69Data[0].Capacity;
                    }
                } else {
                    if (runningCostEstimate == 0) {
                        recommendedModel = 0;
                    } else {
                        countIf = scope.c59c69Data.filter(function(item) {
                            return item.Capacity > runningCostEstimate
                        }).length;

                        var electroCapacitySorted = tempArrData.sort(function(a, b) {
                            if (parseInt(a.Capacity) > parseInt(b.Capacity))
                                return 1;
                            if (parseInt(a.Capacity) < parseInt(b.Capacity))
                                return -1;
                            return 0;
                        });
                        if (countIf == 0) countIf = 1;
                        large = electroCapacitySorted[electroCapacitySorted.length - countIf];
                        for (var j = 0; j < scope.c59c69Data.length; j++) {
                            if (scope.c59c69Data[j].Capacity == large.Capacity) {
                                match = j;
                                break;
                            }
                        }
                        recommendedModel = scope.c59c69Data[match].Capacity;
                    }
                }

                //calculate model input power
                if (runningCostEstimate >= 44) {
                    modelInputPower = 16.12;
                    scope.isShowAlert = true;
                } else {
                    if (recommendedModel == 0) {
                        modelInputPower = 0;
                    } else {
                        for (var k = scope.a76e87Data.length - 1; k >= 0; k--) {
                            if (scope.a76e87Data[k].ReverseLook == recommendedModel) {
                                if (scope.a76e87Data[k].ReverseLook == 25 && scope.a76e87Data[k].Input == 5.8) continue;
                                modelInputPower = scope.a76e87Data[k].Input;
                                break;
                            }
                        }
                    }
                }

                //calculate model
                if (scope.heatTotalData[i] == 0) {
                    tempModel = 0;
                } else {
                    if (scope.heatTotalData[i] > 44) {
                        tempModel = 44;
                    } else {
                        tempModel = recommendedModel;
                    }
                }
                model.push(tempModel);

                //calculate cost/mth/day
                if (scope.heatTotalData[i] == 0) {
                    cost = 0;
                } else {
                    if (scope.heatTotalData[i] == 0 && !scope.withCover.value) {
                        cost = 0;
                    } else {
                        if (scope.heatTotalData[i] != 0 && scope.withCover.value) {
                            cost = 0.5 * scope.electricityCost * modelInputPower * scope.operatingHours * parseInt(scope.monthsanddatesData[i].Days);
                        } else {
                            cost = scope.electricityCost * modelInputPower * scope.operatingHours * parseInt(scope.monthsanddatesData[i].Days);
                        }
                    }
                }

                costArr.push(cost);

                //calculate input-kw
                if (scope.heatTotalData[i] == 0) {
                    input = 0;
                } else {
                    for (var l = scope.a76e87Data.length - 1; l >= 0; l--) {
                        if (scope.a76e87Data[l].ReverseLook == tempModel) {
                            if (scope.a76e87Data[l].ReverseLook == 25 && scope.a76e87Data[l].Input == 5.8) continue;
                            input = scope.a76e87Data[l].Input;
                            break;
                        }
                    }
                }
                inputArr.push(input);

                withCoverVal.push(filter('number')(scope.tempHeatTotal[i], 2));
                withoutCoverVal.push(filter('number')(scope.tempHeatTotal[i] * 0.67, 2));
            }
            scope.withCoverVal = withCoverVal;
            scope.withoutCoverVal = withoutCoverVal;

            //calculate total cost
            for (var i = costArr.length - 1; i >= 0; i--) {
                scope.totalCost += costArr[i];
            };

            //calculate max value
            var max_value = Math.max.apply(Math, scope.tempHeatTotal);

            //calculate minimum output
            scope.minimumOutput = Math.round(max_value);

            var electroCapacitySortedQuantity = tempArrDataQuantity.sort(function(a, b) {
                if (parseInt(a.Capacity) > parseInt(b.Capacity))
                    return 1;
                if (parseInt(a.Capacity) < parseInt(b.Capacity))
                    return -1;
                return 0;
            });;
            //calculate quantity
            if (scope.minimumOutput > 44) {
                quantity = scope.minimumOutput / 44;
            } else {
                if (scope.minimumOutput == 0) {
                    quantity = 0;
                } else {
                    countIfQuantity = scope.c59c69Data.filter(function(item) {
                        return item.Capacity > scope.minimumOutput
                    }).length;

                    // electroCapacitySortedQuantity = tempArrDataQuantity.sort(function(a, b) {
                    //     if (parseInt(a.Capacity) > parseInt(b.Capacity))
                    //         return 1;
                    //     if (parseInt(a.Capacity) < parseInt(b.Capacity))
                    //         return -1;
                    //     return 0;
                    // });
                    if (countIfQuantity == 0) countIfQuantity = 1;
                    largeQuantity = electroCapacitySortedQuantity[electroCapacitySortedQuantity.length - countIfQuantity];
                    for (var m = 0; m < scope.c59c69Data.length; m++) {
                        if (scope.c59c69Data[m].Capacity == largeQuantity.Capacity) {
                            matchQuantity = m;
                            break;
                        }
                    }
                    quantity = scope.c59c69Data[matchQuantity].Capacity;
                }
            }

            //calcualate Require Approx
            if (scope.totalCost == 0) {
                requireApprox = 0;
            } else {
                if (scope.minimumOutput > 44) {
                    requireApprox = quantity;
                } else {
                    requireApprox = quantity / quantity;
                }
            }
            scope.requireApprox = Math.ceil(requireApprox);

            //status
            if (scope.minimumOutput >= 44) {
                status = electroCapacitySortedQuantity[electroCapacitySortedQuantity.length - 1].Description;
            } else {
                if (quantity == 0) {
                    status = '';
                } else {
                    for (var n = scope.a76e87Data.length - 1; n >= 0; n--) {
                        if (scope.a76e87Data[n].ReverseLook == quantity) {
                            status = scope.a76e87Data[n].Description;
                        }
                    }
                }
            }

            //calculate model kw input power
            if (scope.minimumOutput > 44) {
                var a76e87DataTemp = scope.a76e87Data.filter(function(a) {
                    return a.ReverseLook >= 44;
                })
                if (a76e87DataTemp.length > 0) {
                    modelInputKwPower = a76e87DataTemp[0].Input;
                }
            } else {
                if (quantity == 0) {
                    modelInputKwPower = '';
                } else {
                    for (var t = scope.a76e87Data.length - 1; t >= 0; t--) {
                        if (scope.a76e87Data[t].ReverseLook == quantity) {
                            modelInputKwPower = scope.a76e87Data[t].Input;
                            break;
                        }
                    }
                }
            }

            //calculate label
            if (modelInputKwPower != 0) {
                scope.label = 'kW';
            } else {
                scope.label = '';
            }

            scope.model = model;
            scope.costArr = costArr;
            scope.inputArr = inputArr;
            scope.status = status;
            scope.modelInputKwPower = modelInputKwPower;
        }
    }

    function calculateSurfaceArea(scope) {
        if (scope.shape === 'Rectangle' || scope.shape === 'Square' || scope.shape === 'Kidney') {
            scope.surfaceAreaTop = scope.length * scope.width;
            scope.surfaceAreaSide = 2 * (scope.length * scope.depth + scope.width * scope.depth);
        } else {
            scope.surfaceAreaSide = 0;
            scope.surfaceAreaTop = 3.14 * (scope.diameter / 2) * (scope.diameter / 2) + 2 * 3.14 * (scope.diameter / 2) * scope.depth;
        }

        calculateHeat(scope);
        calculateModel(scope);
        if (scope.withCoverVal && scope.withoutCoverVal) {
            scope.chartData = {};
            scope.chartData.labels = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
            scope.chartData.series = ['Covered', 'Without Cover'];
            scope.chartData.data = [scope.withoutCoverVal, scope.withCoverVal];
            scope.chartData.colours = COLOURS;

            if (!scope.isShowAlert) {
                var start = 0;
                var step = 10;
                var max = 50;
                scope.chartData.options = {
                    scaleOverride: true,
                    scaleSteps: Math.ceil((max - start) / step),
                    scaleStepWidth: step,
                    scaleStartValue: start
                };
            } else {
                scope.chartData.options = {
                    scaleOverride: false
                };
            }
        }
    }
}